# College
## Freshman

I enrolled at North Carolina State University in the fall of 2009, majoring in Electrical and Computer Engineering.

I lived at the Avent Ferry Complex, along with Josh and Brendon. The latter two roomed together, while I was placed with a second year EE student from Fayetteville named Parker.

Before I went off to college, I was presented with a Bible on behalf of the church. It's a nice book. I've considered getting rid of it on occasion, but I still have it.

This nice-looking new-in-box Bible inevitably found its way into my things for school. Like all of my things, I found a place for it in my dorm room when I unpacked; in this case, up on the top shelf of my desk. It seemed like the most obvious place to put it.

This spurred a brief conversation with Parker, who it turned out was an atheist. I explained that I was raised Methodist; he didn't seem bothered, though we didn't really talk about it much. I'm pretty sure I had de-escalated to some brand of agnostic by this point in my life, or was at least about to.

---

Unsurprisingly, I took Calculus my first semester. On the first day, the professor asked how many people had taken calculus before. And, basically *everyone* raised their hand. I didn't initially, until sheepishly raising it half-way after a few seconds. The class was a review for most everyone, but I *really* needed first time calculus for people who were *kind of okay* at math.

!embed https://www.youtube.com/watch?v=fOYL-seDv_A&t=128s

I had always been a "B" student at math, despite the whole "computers and ham radios" thing giving me the appearance of being a "math and science kid". This class began a tradition of me always being a "C" student at collegiate-level math.[^10]

[^10]: I think I did alright in discrete math, but I'm not counting that.

Parker moved to Wolf Village the second semester, so I had the dorm room to myself. I spent most of my free time outside of class with Josh and Brendon, who lived on the next floor. I only briefly considered checking out the LGBT center, before deciding I was definitely just a normal dude with some kinks and paraphilias.

## Sophomore

Brendon dropped out of school after his first year and went back to Bladen County. Josh lived at University Towers, getting placed with a roommate named Spencer who he didn't really care for all that much. After initially declaring his major to be Nuclear Engineering, Josh decided to pivot to Computer Science after liking the Fortan class they still had incoming Nuclear Engineers take for some reason. I stayed at Avent Ferry again; this time being placed with an incoming freshman engineer named James Miko. I told my friends I got an Asian roommate because I thought his name sounded Japanese, but he turned out to just be a pot smoking aspie kid from Forsyth county.

I unpacked my things on the other side of Avent Ferry, surprised by the appearance of my new *and very much round-eyed* roommate. I unpacked the Bible and set it on my top shelf again, along with my little Lego NAS I'd built.

Josh, Brendon and I had experimented with smoking funny things our Freshman year, but we weren't too serious about it and didn't really have any connections anyway. I was surprised to find my new "studious Asian" roommate actually smoked weed. I was, by this point, just looking to try "normal college-aged dude" stuff, whatever that was. We started by hotboxing somebody's car with a crappy little pipe and what might've at least been some *decent* granddaddy purple.

This quickly became a habit. We moved from hotboxing the car, to hotboxing the bathroom, to hotboxing the rear part of our room, to really just freely ripping the bong in medium-sized groups while playing Wii Sports or Black Ops or Brawl or some shit. Josh soon made Avent Ferry a virtual second home; and probably regretted choosing to live on the other side of campus that year.

I made new friends and acquaintances through smoking. Trevor, Dillon, Abdul, Jacqueline, Mason, Travis, Bobby... It was generally easier to obtain weed than alcohol.

---

We weren't very far into the year when a group of us were in my room talking; me, Dillon, Miko, maybe one or two others.

> So are you, like, a Christian or something?

> No, not really. Why?

> Well, what's with the Bible?

> Oh; I was raised Methodist. My church gave that to me when I graduated. I still just... keep it on my shelf, I guess.

We all had a laugh about it. I guess they were concerned I might be, like, *really* religious or something.

This was one of my earlier lessons about "normal, secular" life. A Bible just sort of blends in out in the country; and it sticks out like a sore thumb elsewhere. Where I grew up, the Bible wasn't just how you learned about religion; it was a display piece, an accessory, perhaps even an heirloom of sorts. It fills up space on your shelf. It's a centerpiece on your coffee table. It's... the Bible. Everyone has a Bible or six, right?

In a university dorm room however, it becomes almost a sort of political statement. You're on this college campus with atheists and Jews and Muslims and Hindus and yes, sometimes even *Christians*.

You look around at all these people in your lecture hall, and you figure some of us grew up hearing about God and Jesus, some of us grew up learning about Buddha or Vishnu, maybe a couple of us even have family back home who still expect them to pray five times a day. Some of us might've grown up with parents who believed in crystals and homeopathy, some of us might have Scientologists in our family; but I quickly got the feeling that whatever *mythology* we grew up on, most of us didn't take that shit seriously here. We're people of science and logic and reason, gathered here from all the world over to find *actual* solutions to life's greatest mysteries. Religion is for people who need answers now. It's for people who can't handle the mystery and the unknown of real life. It's the opposite of what drives science forward.

---

By some point early on in college, I got the distinct impression that being a "Christian engineer" was *a little weird*. It's like they gave me a clicker question; and it turns out the vast majority of my peers are atheist or might as well be.

I lived in Bladen County long enough to build up a portrait of a "religious person" in my mind: paranoid, overly suspicious, authoritarian, afraid of everything, xenophobic, easily angered and upset by things they don't understand. They crave the antidote to this: heightened surveillance and security, increased scrutiny, arbitrarily fewer degrees of freedom, a reduced number of unknowns that might spook out "us decent folk"; a return to a simpler time with fewer questions and fewer problems.

I had similarly built up a portrait of what I began to consider a "normal, secular" person: easy going, live and let live, tolerant of alternative lifestyles, assumes the best but prepares for the worst, open-minded about new information; is generally prepared for the challenges of modernity. They want to watch a new generation cast aside the superstitions of their parents, and add a feel-good chapter to the history books for once. They want to see the people have more freedom; they want an end to arbitrary inequalities. They want to see progress where there's been none for *centuries*. They quickly lose patience in debates over whether gay marriage is "unnatural", or whether stem cell researchers are "playing God".

This discussion has gone on longer than I would like; anyway, I put up the Bible not too long after our talk. As I'm older, I think of this as an example of "positive" peer pressure.

---

I probably could've stood to focus on my studies more; but, I was just glad to finally be part of what felt like a *normal* group of friends. It seemed like I'd escaped Bladen County, and the ostracism I felt through much of high school. I'd come to view my earlier behavior as a "weird phase" where I thought I was trans, and was relieved to feel as if I had finally assimilated myself into "bro culture". I was drinking, smoking, doing drugs,[^11] enjoying first-person shooters... it felt like I'd mastered everything there was to being a guy, except for the "fucking women" part. This, frankly, felt more valuable to me than anything my professors could teach.

[^11]: Cannabis and psychedelics folks, cannabis and psychedelics.

I grew a little nervous as we let our guard down more and more. The normalization of danger reminded me of my earlier habits.

We eventually *did* get busted while smoking in Trevor's room at the very end of the year, during finals. Trevor happened to have a handicapped room[^12] with an extra-large bath we liked to hotbox, which could hold nearly a dozen heads. An RA apparently overheard us talking about getting high on the way to Trevor's room, and alerted the campus police. Josh narrowly avoided getting caught, as he was at UT studying for an exam.

[^12]: Trevor wasn't handicapped; he just got lucky.

The matter was handled by student conduct; and, began coloring my negative perception of law enforcement, despite them not exactly being the "real" police. First of all, they accused us of having close to an eighth when we started the night with no more than half that; probably because they just plop the whole baggie on the scale. It's not that an eighth is any more illegal than a gram; it's just obnoxious when the neighborhood drug dealer is more honest about weighing your weed than the cops are.

Whatever.

A few disciplinary actions came out of this, ultimately.

* We couldn't live in on-campus housing anymore.
* We had to write a letter for student conduct to send back to our parents explaining what we'd gotten in trouble for.
* We had to receive a substance abuse evaluation from a licensed counselor, and follow up on any of their recommendations.
* We had to complete a question and answer-based writing assignment.
* We were all on disciplinary probation for varying amounts of time, so we couldn't fuck up again.

I already had plans to move into an apartment next year anyway, so the first item was a non-issue.

The second item was still less dangerous than ordering spironolactone from Vanuatu; I was home for the summer working , and saw nothing to lose by simply hoping to check the mail first.

For the third item, I looked up practices in neighboring Robeson County that offered substance abuse evaluations, and picked the chillest sounding one. I talked to a former heroin addict-turned counselor, and I had to follow up on his recommendation of attending two Narcotics Anonymous meetings so that I could see what harder drugs might lead to.

I was able to complete all the things over the summer without any trouble, and without Susan finding out. My friends had variously more difficult times; Trevor probably had it the hardest with an intensive counseling program over the summer, and I think Miko had a longer probation for being a hard-ass to student conduct.

I still think it was bullshit that they wanted to tell my crazy mom, when she contributed *nothing* in college savings. I paid my entire way through college with loans and Pell grants and scholarships and a summer job; if anything, she was siphoning money out of my checking account to pay for our "car insurance".

Something that's always bothered me, was the seemingly arbitrary and wide variance in the rulings issued. Me, Miko, Dillon, Trevor, Abdul, Jacqueline... we were just a bunch of pot heads who lived at Avent Ferry. We smoked in each other's rooms and cars, we each had and shared our own pieces, we bought weed from the same pool of drug dealers, often splitting it amongst ourselves...

Student conduct (or more generally, "the cops"), are very particular about all their little offenses and bullet points. "Who was in possession of the paraphernalia? Who was maintaining the dwelling?"; As if we followed Robert's Rules of Order. Now, even the more honest cannabis user who'd just as soon say "Guilty your honor, I'm a pothead" finds themselves in the uncomfortable position of having to "get their story straight". Sure, we had Josh's vape, and Miko's bowl, and the green bong we all chipped in on; but we used *my* monogrammed bookbag to move our pieces around, so naturally we're going to say "Ethan was in possession of the paraphernalia" when we give our official statements to student conduct. Because, it's utterly illogical to just pile more names onto that list, and if we were *totally* honest we'd have to include Josh who wasn't even involved otherwise.

This experience taught me a lot about how the criminal justice system works, despite the lack of criminal charges associated with it. Between things like plea bargains and the rapidly escalating need to "keep everyone's story straight" as more than a couple of people get involved in an endeavor, I imagine relatively few folks are behind bars for something they *actually* did. That's not to say they aren't necessarily guilty of *something*.

---

We (or rather, Susan) moved to a different house around the corner, as the one we'd been staying in was now slated to be torn down to expand the church playground.

I helped with the move in between working at the computer shop and handling my student conduct bullshit. Keith let us repaint the walls, which Cody and I did.

I'd often put on music while I was working in the new house over the summer. I had my little iPod touch with a Sony dock, and I'd put on... whatever I guess, as background noise. I think I'd put on the Red Hot Chili Peppers album *By the Way* when my mother came in and incredulously exclaimed "What is *that*?!"... as if the fucking Zephyr Song was too hardcore for her or something.

If you're growing impatient with this dull anecdote, I *promise* I'm going somewhere with this. It's gonna take some time, though.

This is a good example of my mother's behavior, that leads me to hide things from her. It's not like I was *in trouble* for listening to the Red Hot Chili Peppers or something. But, she also wasn't like "Hey, that's groovy Ethan! Nice music! Glad you're putting that iPod I bought you to use!" It's even more confusing that I grew up with my mom playing Q98 in the car. Like, I didn't think this was some "foreign genre" for us. I wasn't sure what to make of it - but I didn't play any more RHCP around my mom, and was probably more conservative with my music selection in general around her after that.

Maybe I misread the situation, because it wasn't long after this that my mother bought Josh and I tickets to see the Chili Peppers at PNC later that year, and similarly bought me a t-shirt to go with it. It might be worth noting that this is a band I'd never explicitly mentioned that I *like* to my mom. I think the occasion was my birthday, which was just a couple of months after the move.

Perhaps more unusual were the seats. My mother was about to buy Josh and I regular seats, when Terry gave her money to buy us floor seats. Because... we're such good kids, I guess?

The show was supposed to be later that year; but was moved to the spring after Anthony Kiedis broke his foot.

## Junior

I moved into an apartment at Wolf Creek my third year, along with a lot of other folks. Josh and I already had plans to take the places of graduating seniors Marc and Noah, moving in with remaining Bladen County native Will Potter; who was ostensibly going to NC State for *something*, it's a matter of debate.

The other people I got busted with had to scramble over the summer to find housing; with Miko, Dillon and Trevor also finding spots at Wolf Creek, although not all in the same apartment like they'd have preferred. Over the course of the next few months, the remaining three consolidated themselves into a smaller number of apartments as space became available. Trevor would eventually move in with me, Josh and Will for my senior year.

---

I believe it was in the fall, when we had this "homecoming Sunday" at my old church. Tommy returned as a guest preacher, and we had a lunch afterwards in the activity building. I found myself at a table with Tommy, the Richardsons, the Stewarts, my mother... I'll be damned if it wasn't the same crowd as when we first *met* Tommy all those years ago.

We were making small talk, when the conversation turned to this weird nightmare I had as a kid. Basically, I thought "sharks" were going to eat me; but, it's a little more complicated than that, and this was the first time my mother and I effectively *communicated* about the content of this dream.

"Tell them about the sharks!", my mother says. As if to put me on display.

> Oh... you mean the shark people?

> Wait, they were *people*? You never said they were *people*!

> Well, they had arms and legs...

> What did they look like?!

> Well, they were gray...

I started to notice some of the others at the table exchanging glances. As I continued telling this story, which my mother seemed more interested in *now* than when I woke up screaming all those years ago, it felt like you could cut the tension with a knife.

> Did they have big jaws?

> No, not really...

> What were they doing?

> Well, just standing over me mostly. We were in this strange, round room, and I was on this metal table.

> How tall were they?

> I don't know. Like... normal human height?

> Were you scared?

> Well yeah, I thought they were going to eat me!

It was about this point when Tommy decided he needed to have a talk with me *right*. *Now*. He practically dragged me out of the activity building by the forearm.

We walked out into the church parking lot. It was looking pretty empty by this point in the dinner, but there were still cars and people around.

We got to the center of the parking lot. Tommy looked around us. There wasn't anyone in earshot. It wasn't. Private. Enough. We kept walking. Out to the far, northwest edge of the lot. He was brimming with excitement. He looked as if he could barely contain himself.

Tommy looked around us again. There was *nobody* around.

> You're different.

> I know I'm pretty weird...

> No. You're **different**. You aren't *like* these people, see?

"You aren't *like* them!" he says again, gesticulating wildly at a couple of people underneath the covered walkway in the distance. Church, organized religion, the "Bladen County" life... he made it abundantly clear that these things weren't. *For*. Me. They were for *them*. They weren't for *me*. I was *different*.

Shit, man. This is pretty weird. I'm pretty sure my preacher just told me *not* to go to church. Not that I was planning to anyway...

I'm obviously unable to precisely recite the conversation from memory; but, these were the bullet points.

* I'm different. *Very* different. I need to learn about how I'm different, and Tommy can't teach me.
* I need to "seek hidden truths". 
* "Freemasons" know about different people like me.
* "If you walked into a masonic lodge and gave them your name, they'd know who you are."
* He made it sound like I needed to explore some sort of spirituality that was "beyond church". He said that Freemasons know about it, but so did other groups.
* My mother... is not to be trusted.
* He seemed to know things *about the future*.
* He said my mother and I would have a falling out. That I would ban her from my property.
* I hope I'm not projecting recent events on the situation when I tell you I remember him saying it involves *UFOs*. And that there would be a *UFO report* in the future.
* He said there were "things going on I should know about".
* He reiterated that church wasn't *for* me, but that it was important I keep exploring spirituality. He told me I should find a group of people to learn about this stuff from, and that perhaps one of these groups that isn't "Freemasonry proper" might be the best fit. This was a long time ago, but I *think* he used the word "coven".

He went on to describe a sort of "vision"[^21] he had, where I was to show up at his new church years from now.

[^21]: I think this whole "vision" thing is bullshit; but, I'll allow it as an oversimplification.

> This is gonna sound weird... but, you were wearing a purple dress.

I was *not* out of the closet to Tommy; and in fact, had abandoned my plans to transition *at all* by this age. My face was probably very red.

He also made it sound like I would go on to make some unusual lifestyle choices; but, that it was okay. It was my path, actually. I... think polyamory might've been mentioned.

I didn't know what to do with all of this. Tommy and I eventually returned to our table.

When we got home, my mother asked nosily what Tommy and I talked about.

I didn't know what to say; especially since half of Tommy's advice seemed to be about how I *shouldn't* trust my mother. Can't she see this was a private conversation for a reason?

> Oh, Tommy just talked to me about the Freemasons. He thinks I should... join them, or something.

I feel stupid for telling her *this* much. It seemed harmless enough, though. I wanted to satisfy her curiosity.

My older self would've told me the woman's curiosity simply *isn't satiable*.

I thought about joining the Freemasons; but when I looked them up online, it was clearly a fraternity of men who believe in God. And, I was an atheist quasi-transgender subby boy; or, whatever it was I identified as back then. Even if I wasn't planning on *transitioning*, I was generally irked by things that were gendery or exclusively male.

I was also unsettled at the news that my future self *might* choose to transition after all. Medical transition is something you should do *sooner* rather than later, and I wasn't unaware of this. I just... couldn't stomach it back then. I'd finally made it to *normalcy*, after years of being a *pariah*. Can't I just be a pot-smoking dude bro? I don't suppose Tommy might be *wrong* about all this...

---

I turned 21 at the beginning of my junior year, which was cool; though I can't reiterate enough that *cannabis* has always been my vice.

Now 21 years young and an upperclassman, a couple things were weighing on my mind.

* I wanted to do *other stuff* on campus, besides going to class and hanging out with the same friends every night.
* I need to get laid.

I decided to join the IEEE robotics team around this time. I participated my junior and senior years; it was fun and I learned a lot, but the team lacked faculty advisement, which I think ultimately caused us to struggle in delivering a working robot. I did drink *way* too much Fireball at SoutheastCon once, though.

A full autobiography would include a more complete retelling of my experiences on the IEEE robotics team; however, that would be irrelevant to the purpose of this document.

### The IEEE robotics team

I knew I was at the age where I should be having sex. I also knew better than to just start asking sorority girls to top me. I felt like my sexuality was utterly incompatible with the mainstream dating world; and I was still *very* deep in denial about the possibility that I *might* just be psycho-sexually "a woman".

Of course, I've known *BDSM* was a thing since I was in seventh grade trying to figure out why I liked tying myself up in mom's lingerie so much. I just wasn't old enough to *do* anything with that yet.

I went to my first evening meeting of the IEEE robotics team in January 2012. I was hoping my roommates wouldn't ask questions, but they probably did. They... usually did.

I sat in the car for about fifteen minutes, looking at the Cary IHOP in the rearview mirror. Like I was about to drop acid for the first time or something. But, I went in. I was a "take the red pill" kind of guy.

There were a vertigo-inducing 75 people crammed into the side room at the IHOP; a record-breaking turnout for any TMG munch, that may not've been paralleled since. Maybe everyone had a new year's resolution to get back in the scene before the Mayan's ended the world or something. I could scarcely find anywhere to sit; but I did manage to find a spot after some effort, and I didn't even have to bang my trumpet case around.

I left with a couple new acquaintances, but I was looking for something that was both less overwhelming and closer in age range. Seems easy enough; I just have to wait for TNG.

The next TNG munch was at Tyler's in Durham. I showed up to the restaurant 45 minutes late, because I'd never been to the ATC before and the GPS kept sending me by the Moe's. When I *did* find the iconic Durham establishment, the wait staff didn't know where "TNG" or "the computer group" was sitting, so I left. I remember hearing later that this was a weird one anyway.

I probably went to another TMG munch before making it to the next TNG at Tyler's, not at the ATC but at Seaboard Station this time. By now, it felt like an eternity had passed since I started *trying* to go, but it was really only like March or late February. I remember seeing some now-familiar faces there. Erika, Jason, Ian, Isabel, Emily... I remember this other fellow Josh going on about different strengths of alcohol he'd tested for his firecupping demo[^13] when I thought to myself, "I have *found* the sex nerds".

[^13]: The answer? It's been a while, but I think it was regular 70% isopropyl alcohol.

I went to my first play party a couple weeks after this. Josh gave his firecupping demo, an unusual but not unheard of feature. It was cool.

I kept going to stuff. I got in the loop for the TNG slosh that was very much undocumented at the time, kept going to play parties and shit... I was starting to wonder if I was doing it right, when I got my first scene in with a woman named Maureen.

Maureen is a fascinating woman deserving of her own paragraph. For the entire time period I've known her, Maureen has been in a relationship with a much younger fellow named Isaac, who for the longest time was a grad student at UNC and is only a couple years older than I am. I often refer to her as "Maureen the cougar" in my head because of this; however this is a misnomer, as the relationship was in fact initiated by *Isaac*, who I suppose has a thing for older women. She was otherwise over the age limit for TNG, but Isaac often guested her into the parties; she also showed up to the unofficial slosh we had at the Saucer quite a bit.

Anyway, some of you might not really understand how the "BDSM community" works, and might be under the mistaken impression that a play party is tantamount to an orgy. While there's certainly no shortage of kinky orgies in the world if you were to meet those sorts of people, that would also be a *considerably* more private affair.

!embed https://youtu.be/eKrN4vNsBzA

Play parties typically involve partial or full nudity on the part of the folks getting tied up and beaten with stuff, but there are clearly defined rules of engagement that prioritize enthusiastic informed consent and generally preclude outright *sex*. Where sex at play parties *does* happen, it's usually in more intimate group settings, and at a house party as opposed to a venue.

So anyway, it was probably around May, and we were at Justin's house for TNG instead of the Hangar like usual. This fellow Justin used to throw house parties fairly regularly before he moved to Texas. And no, this wasn't a "kinky orgy"; though Justin's house did have a well-deserved reputation. We could also drink there, which was typically both prohibited and legally problematic at an actual dungeon or venue.

I'm starting to wonder if I should be *doing* something other than existing as a subby boy at a play party who's only preoccupation is his whiskey and coke, when I'm approached by this middle-aged woman. I've seen her around before. Not sure if I ever got her name. Maureen sat down next to me on the floor, and asked if it was alright if she touched me. We went through her toy bag and did some light sensation play, just sitting there like you do. She knew it was my first time. Eventually we did a proper impact scene once the equipment was free. Nothing crazy. We went through her floggers, and maybe some paddles and canes. Just your standard routine. I figured I was starting to make progress. Maybe I wasn't doing it wrong after all.

It wasn't too long after this that I started doing stuff with Erika. We did the Sunday brunch munch they had in Fuquay at the time, and wasted time sitting at Starbucks and picking up snacks before rope practice early that afternoon. We joked about how everyone including the staff at Golden Corral kept trying to ship the two of us, and we sort of hit it off from there.

Erika, to be clear, was always a *play partner*. This wasn't a romantic relationship; it maybe *could have become that* under different circumstances, but I lacked desire, and probably don't even have the DLLs necessary to seduce women without crashing.

---

Josh and I finally got to attend the aforementioned Red Hot Chili Peppers concert in the spring.

This was fun; but probably got the two of us a little *too* high for the pyrotechnics that ensued. We were both starting to wonder if we were too baked for this shit, when they started playing "Under the Bridge" and we both knew we were going to be okay.

We walked through the gates, and were confused at first when security marshaled us onto the floor instead of level 1. "Oh yeah... My mom said Mr. Terry got us floor seats for some reason."

The *weird* part of this story were the people sitting around me. They all appeared to be... *in on something* I was not. They all seemed to be part of the same group, despite only now introducing themselves to each other. I didn't think much of it at first. They were mostly sitting on my side, to the left and back of us.

The show opened with the song "Right on Time". One of *those* people giggled to whoever was next to them at the line "Joan of Arc reincarnated". "I love that part!"

I overheard a bit about it being her first time seeing the Chili Peppers since... something. I similarly didn't think much of it; and I'd never heard the song before that point.

We kept watching this show, stoned out of our minds. Midway through, they played "Can't Stop". This was my favorite song by them at the time; so whatever hooping and hollering I was planning to *do* at this show, this was it. Some lunatic several rows in front of us stood up on his chair while wearing a Subaru t-shirt.

I don't know if it was my enthusiasm or something else; but it was at this time, maybe at the end of the song, when another of *those* people taps me on the shoulder. It was a woman sitting behind me, middle-aged or perhaps slightly older. And, she asked me the most seemingly innocent question.

> Where are you from?

I told her that I was born in Ohio, but grew up in southeastern North Carolina. This... didn't answer her question.

I don't precisely remember how the conversation continued; but, the woman's follow-up responses were cryptic, and it was around this time when I exclaimed something to the effect of,

> A bunch of y'all keep acting like you know something about me I don't know! It keeps happening! I've got people from my hometown, people from church...

She responded with something vague like "Keep searching... you'll figure it out..."

It was in the banter that continued with this woman and others who joined in on our conversation, when somebody hinted to me

> "... You need to learn *the truth about UFOs*."

---

This was the first summer where I didn't go back to mom's house to work at the computer shop. I managed to get an internship at Fidelity; I frankly didn't have the *grades* to get one at a real tech company. I did very well in my programming and digital logic classes; but was quite dreadful at anything to do with hard math or analog circuits. I probably should've switched my major to Computer Science at this point, but I powered through out of my love for embedded programming; and also out of the knowledge that I *really* didn't have the money to keep being a super senior or beyond.

I found myself in hot water after setting up a playdate at our apartment, when I *thought* all of my roommates would be out of town. Somebody, I think Josh, decided he was about to drive back from the lake *like a couple hours* before Erika was coming over. It was too late to call it off, and I kinda just started drinking beers and planning to tell Josh I was a kinkster when he got back. I somehow managed to divert Josh's return trip at the last minute, but I *basically* told him I was having a girl over. I started to think I was only delaying the inevitable.

---

Josh's brother stayed at our apartment for a while in the summer while he attended a summer camp at NC State during the day. I remember him coming back with a story one evening.

> I met this girl. She said she was pansexual, and that there were like twelve different genders!

I died a little inside.

## Senior

We moved from a three- to a four-person apartment in the same complex; eventually adding Trevor as our fourth roommate after briefly being stuck with a stranger from Wake Tech who we didn't really get along with. My roommates were wise to the fact that I had *some* late night extracurricular I didn't want to talk about, and "robot team" become a sort of joke at our apartment.

I thought about telling my roommates. I *really* did. Things got increasingly weird as I ran out of excuses for what I'd been doing out so late. The world wouldn't have ended. There were a lot of reasons *not* to, though.

* BDSM is radically accepting and body positive. My roommates... were not.
* I've heard Josh complain about merely having to *Skype* with fat girls for schoolwork. He calls women "fat" who aren't even fat! And here I am, play partners with Erika.
* Have you ever read "If You Give a Mouse a Cookie"? These guys had a habit of screaming **BULLSHIT!** any time I made a claim even half as sensational as being *actively involved in the local BDSM community*. I was concerned they might, well...
* So, my roommates were the sort of people Dakota would probably yell "Code pink shirt!" over the walkie for trying to slip past the gate at Debauchery, if you know what I mean.[^14]
* So, what I meant to say was, I was concerned they might make asses of themselves. And that they *did* sometimes wear pink button-ups unironically.
* Or, that they'd demand I "bring home a dominatrix".[^15]
* Also, I can't un-tell them. Like I wish I could've done back in ninth grade.
* Would Josh want to tape up his asshole around me again like after he learned I was trans?
* They were the sort to argue over whether Cameron was "gay" for enjoying pegging, when I probably had friends who matched the database query `Gender = 'M' AND Orientation = 'heterosexual' AND Fetishes LIKE '%Pegging (Into)%'`.
* My roommates are looking for *hot college babes*, not 18-35+ kinksters of various body types. The mouse is gonna bother the piss out of me until I give it a cookie, then proceed to complain about how my food sucks and I'm really just a pussy.
* And, my roommates are into the *normal dating pathway*, where you find yourself a nice woman to seduce, go out on a few dates, take her home to meet your parents, maybe pop the question and talk about having kids some day... BDSM is notorious for unconventional relationship dynamics like polyamory and wide age gaps, that my vanilla friends would probably find weird or even *creepy*.

[^14]: You... probably don't know what I mean. Just... ask me later, okay?

[^15]: Will said something once that made me think he *might* be into that sort of thing. It's probably a stretch, though.

It kinda seemed like the *best case* scenario would be for this to remain my private little solo activity, which is what was happening anyway. I figured it was obvious I was doing "weird sex stuff" of *some* sort; and that maybe some things were better left unsaid.

!embed https://www.youtube.com/watch?v=xjhQe5NUFvA&t=12s

Living a double life soon proved to be a challenge, and I struggled to keep up. I was always double-booking kink and vanilla activities, and I really should've kept a schedule.

Erika's engagement with a fellow named Kevin collapsed over the summer. While I'd love to tell you all about it, it's mostly irrelevant; save for the fact that Erika now expediently needed a place to live, and she wasn't made of money. She ended up moving into the spare bedroom of Heather, a (vanilla) friend of Justin from TNG. I think they used to work together or something.

### Heather

When I was around this age, I often thought of what my life would be like when I was older. Because, I wasn't planning to transition anymore. I wasn't planning to be anyone's husband. I didn't want children. What was I, just going to live in a giant bachelor pad by myself my whole life with all my engineer money I didn't have anything else better to do with?

As Erika's move inched closer, I began hearing more and more about this Heather person.

* Early 30s
* Software engineer
* Used to work with Justin at Cisco or some shit
* Bachelorette
* Still gets high
* Lives in a giant house just outside the beltline, either by herself or with discretionary roommates *who are statistically more likely than average to have natural or artificial red hair*, probably by sheer coincidence.[^16]

[^16]: Her residence has at times been referred to as "Heather's home for wayward redheads".

As I learned more about her, Heather was the first person I'd met in my field whose adult lifestyle felt *relatable* to me. I'd often wondered if there was a place for me in the world, as a man who wasn't a "marriage and family" kind of guy; but now I figured I could just grow up to be a sort of subby-boy Heather type of character with a basement dungeon.

I helped Erika with the move, and often found myself at Heather's house my senior year; eventually getting the door code to let myself in. The room wasn't huge and there wasn't much space to swing a flogger around, but it was certainly more discreet than my apartment situation.

We started getting to know each other during and just after the move.

> What do you do for work?

> I'm a student at NC State.

> Oh! What's your major?

> Electrical and computer engineering.

> Oh, ECE! Is Mrs. Such-and-such still the advisor over there?

> Yeah! How'd you know?

> I used to be in ECE before I switched to Computer Science. My advisor hated me for it, too. I was one of her favorite students.

She talked about how the predecessor to ECE220 was *way* too hard, and they eventually had to restructure the class because of it. It sounded like she switched out of the program largely because of this, and went on to get her master's in CS.

---

Early on, I had the most *fascinating* conversation with Heather.

I overheard her say something about going to a *pagan meetup* when I was over visiting.

This... piqued my interest. At the risk of sounding cheesy, I saw Heather as a sort of role model. I thought of her as someone who was, probably, a better version of myself. We're both people of *science*; and as I've grown up, science has caused me to believe in *fewer* gods, not more of them. But here she is, worshiping a whole pantheon of them! That's assuming she's sincere in her convictions, at least.

Naturally, I was curious why she believed as she did; and, my ears were still ringing with Tommy telling me I was "different" and needed to "seek hidden truths", or perhaps some alternative form of spirituality.

When I pressed for more information, she got defensive at first. "That's private!"

I told her I didn't mean any disrespect; and went on to explain I was only curious because my childhood preacher acted like there was *something else* I needed to know that was beyond religion. And that I was apparently different in some way that involved the Freemasons.

> Ooh, Freemasons! How much do you know about Freemasonry?

> Uh... not much...

> Bullshit!

> No really, this guy Tommy just kept pulling me aside and acting like I needed to learn something about myself. And... it involves the Freemasons, apparently?

> Huh... you really *are* new at this, aren't you?

The conversation continued. And... it only gets weirder from here.

> Who do you work for?

> Well, I'm a student.

> ... Does anyone in your family work for the government?

> Well, my mom works for Cumberland County DSS...

She seemed... unconcerned about that last part.

> What do you believe in?

> Well, I'm an atheist.

> So... reincarnation is real.

> ... Sorry, I don't...

> No. It's real.

She was so matter-of-fact in stating that last part. Like a doctor reading me my diagnosis.

She went on to explain that there's... life on other planets. And, reincarnation is real. And, she happens to be from a planet orbiting the star Vega in the constellation Lyra. Apparently, these people are simply described as being "from Vega", or "from Lyra".

I... wasn't sure what to do with this information. I couldn't help but take it with a grain of salt; but Heather just sounds so *goddamn serious*, and she's smarter than I am!

I wanted to learn more. I was still a bit "citation needed" on the inside, but it *did* seem related to the thing Tommy was trying to tell me. Heather didn't have any resources to give me, and simply told me to "explore mysticism". "Keep learning... you'll get there someday." I think she said something to the effect that it would be more of a thing in another decade or two, but it wasn't really talked about today.

I looked up the Wikipedia page for "mysticism" when I got back home, but that wasn't exactly helpful. And, it didn't make me any less of an atheist. Still, I was fascinated by the whole "reincarnated space alien" thing; it *was* an obvious consequence of reincarnation, and one which I had never considered. However, it was unclear how this ties into *paganism*; that aspect probably yields more questions than answers.

---

The next time I went over there, Heather called up one of her friends to have *her* come over as well. It seemed she wanted us to meet; or that there was otherwise some purpose to this visit.

When her friend arrived, Heather proceeded to put on a sort of little demonstration; which she wanted to explain to *me in particular*. I... *don't* remember all the details. Oh, how I wish I remembered all the details...

This had to do with Freemasonry; and how you're supposed to talk about it with "people like Heather". It was like this sort of "Simon says" routine you have to do with them. It went something like...


|                |                                         |
| -------------- | --------------------------------------- |
| Heather          | How much do you know about Freemasonry? |
| Heather's friend | Oh, all sorts of things!                |
| Heather          | Alright, now ask me.                    |
| Heather's friend | How much do you know about Freemasonry? |
| Heather          | Not much.                               |
| Heather's friend | Bullshit!                               |


I feel like I'm missing parts; but I do remember part of this Freemason `sudo` command involving the Heather-like person lying and *you* having to call them out on it. As if they could only tell you something *once*. I distinctly remember Heather's friend boldly exclaiming the phrase "Bullshit!". I don't remember if it's required to utter *that specific profanity* or not...

### High jinks

I had a lot of adventures and close calls while living a double life my senior year. While irrelevant to the story, I *would* like to share some of them.

---

For my 22nd birthday, Erika set up this playdate for us to go to Bailey's house.

Bailey was a student at Duke at the time. She was one of the few dommes[^18] in the area who was my age, so I was excited to see how things went.[^19]

[^18]: Erika is really a switch; and certainly not a domme in the D/s sense.
[^19]: I don't know, because I thought I might actually be a straight guy or something?

Erika picked me up at Wolf Creek on Friday afternoon, and we drove to Bailey's town house off Duke St. We'd go upstairs to scene, and then go downstairs to unwind for a bit, and for Bailey to have a smoke break. And, we did this a few times.

During one of our breaks, Bailey says

> So, Erika tells me you're transgender...

One thing led to another, and, anyway, I found myself getting birthday spankings in a mini skirt.

Erika would often later bring up how much I seemed to enjoy myself in this moment; as if to suggest I might have unresolved feelings about my gender identity. I couldn't help but look to how *hard* I was during all of this as evidence that it probably *was* a sex thing after all.

What else? Erika gave me a collar, and a set of matching bondage cuffs to go with it. I think we went to Cook-Out. We ended up spending the night.

My mother was driving up on Saturday morning to see me for my birthday, so I needed to be back at my apartment before then. We were running on "Erika and Bailey time", and we were not making the return trip as quickly as I'd have liked. I was trying to avoid a situation where I might have to introduce Erika to my nosy mother, or explain *why I wasn't home on a Saturday morning to see a-widdle muver for my birthday*.

My mom was leaving Benson. We were on our way to get gas before leaving Durham. This was *close*. A real race condition. Plus, I needed to *shower* and whatnot. I'd be lucky if my mother didn't catch me darting out of a gold Suzuki with a duffel bag like I was storming the beaches of Normandy.

I appeared to just barely beat my mother. I jogged up the stairs and power-walked to my room.

No text messages from Susan, and I didn't see a blue Focus anywhere. Phew.

I. Need. A shower. Susan can wait. She knows where the McDonald's is. I waste no time.

I dried off. I brushed my teeth. I put on some boxer shorts that I'd replaced my childhood tighty whities with after wanting better looking underpants, and probably grabbed some cargo shorts and a band tee or something, as was my uniform in those days.

I checked my phone. Still nothing from Susan. I combed my hair. I took one last look in the mirror that also served as the closet door.

I'm still. Wearing. Eye shadow. It's really obvious. It did *not* come off in the shower.

Fuck.

So, I start scrubbing the *fuck* out of my eyelids with the corner of a bath towel and some hand soap. It's *really* stubborn. Have you ever tried removing makeup without makeup remover? They sell it for a *reason*.

I'm starting to wonder if I even *can* get it off completely. Maybe it's like when you go to the club underage, and you just have to accept you're going to have the ghost of a Sharpie 'X' on your right hand for the next day or two.[^20]

[^20]: I got dragged to the club *once*. I don't like the club. Maybe I'd like it more if I were a woman or something.

Eventually, I succeed. I carefully inspect my eyelids under all available lighting, and I can't find any more obvious signs of makeup. It took me long enough, though.

I take a deep breath and check my phone again. Still nothing from Susan. Surely she's arrived by now?

Anyway, I finally open the door to my room. At long last.

I'm surprised to find my mother sitting at the kitchen table and staring *right at my bedroom door*. That's one question answered.

> Do you *always* leave your door unlocked?

> Uhh... no... we usually lock it...

> Somebody could just *walk right in here*... I'm serious! Has it been open all night?

> Uhh... no... I just took out the trash this morning, or something...

> There are crazy people out there! You need to be careful!

> Okay, we will...

> ... I bought you those headphones you asked for...

I'm just glad she didn't ask who "Marseille" was.

---

Erika was a semi-professional photographer. It certainly wasn't her day job, but she did side gigs for people and whatnot. One of these gigs involved the North Carolina Fetish Art Festival.

The door for this thing was at least $20, and I think more like $40. Erika was obviously getting in for free, and she managed to get me in as well as her "camera assistant".

The dress code was "fetish attire or all black". I planned to do a blacked-out look with my red collar. I needed to buy new clothes for the occasion and was laughably inexperienced at finding what I was looking for, but I pulled it off. That's, unsurprisingly, not the point of the story.

First of all, I double-booked NCFAF with some big tailgate our apartment had planned, and I didn't realize what I'd done until like a day or two before. It was difficult to back out of *either* obligation, but Erika and I had been planning this for at least six or eight weeks. So I chose... both! This was probably not the greatest idea, but I made it.

!embed https://www.youtube.com/watch?v=jiqhvagCy4M&t=59s

I rode along with my roommates to the tailgate lot; but, I *knew* I couldn't stay for the game. So late that morning, I just *walked back* from Carter-Finley to Wolf Creek, took a shower, *maybe even picked up some last-minute article of clothing I was having trouble finding at Belk or some shit*, eventually making it to Holly Springs in time to get ready for NCFAF with Erika.

We disembarked, joking about how we looked like we were on our way to the kinky prom. When we arrived, they gave us special lanyards, as we were considered "staff" or whatever. They didn't have a second "photographer" lanyard, so they gave me one that said "vendor" instead.

I *really did* hold Erika's camera bag for her, and it *really might've* been a two-person job to juggle all of that, in all seriousness. I also bought myself a couple Yuenglings at the bar, so I'm not a *complete* scrub.

They didn't seem concerned about collecting the staff lanyards at the end of the night. Erika and I left with both of ours. We drove through Cook-Out on our way back to Holly Springs. It wasn't really a *play party*, but it was fun. Sort of like a mini-PUSH.

Anyway, some amount of time after this, I needed work done on my car. The work included a new muffler; maybe I couldn't pass inspection without it or something.

There was (and still is) this mechanic beside the apartment complex called RJ&G. Unless you're going to have friends drive you around or call an overpriced taxi, this was really the only place to take your car within walking distance for car shit. We were kind of in a weird area between Raleigh and Cary, and I don't think ride-sharing apps had become mainstream yet.

I dropped off my 2001 Mustang at RJ&G for a new muffler, and probably came back in a day or two once they were done.

When I went in to pick up my car, the staff was *unusually* jovial with me. "We bet you *get around* in that Mustang, don't you! She's seen some *things*, hasn't she?" And I'm just like "Sure, whatever." I pay the bill and they return my keys.

I returned to my car, with two *very obvious* new additions to my floorboards.

* Those paper mats they put down after they vacuum your car.
* A lanyard that says "North Carolina Fetish Art Festival: Photographer".

---

#TODO Unfinished but largely irrelevant

A group of us would regularly meet at this woman Dana's house in Garner, for an even that came to be known as "Ponies".

I'm... not a bronie. I'd *tell* you if I was at this point. The event's name came from Erika, Dana, and a small group of folks who actually *did* follow that series as adults; but had since moved toward other media, as a number of the newer attendees weren't really into that, or were even put off by it. I think we were doing The Walking Dead at the time, and probably Archer and another series or two.

This was a *mostly* vanilla gathering of kinksters, that would sometimes devolve into a kinky gathering of kinksters. This happened *just* often enough that you probably couldn't bring your vanilla friends along without explaining how we all know each other.

#TODO I'll write more about BDSM eventually, but this is mostly irrelevant.

#TODO Vanilla life senior year

---

There was this Women and Gender Studies class that was required; certainly of all the *engineering* students, but probably just everyone in general. Josh took it before me and *hated* it.

Being a quasi-transgender subby boy who was thoroughly acclimated to "consent culture" through time spent in the BDSM community, I expected to like the class a bit more than Josh. This, unfortunately, wasn't really the case, and I found myself bitching about it a lot to Josh throughout the semester.

This was a long time ago, mind you. I feel like one of the problems was that, despite considerable effort to the contrary, it made a lot of assumptions about you and your life as a guy. A big one was that you had *women in your life* (your mom, your girlfriend or ex-girlfriend(s)) to whom you owed *respect*. Because the women in our society are responsible for shit like *emotional labor*.

While this might often hold true for "normal" people, this kind of made me feel icky. Like I still wasn't wuving a-widdle muver enough, and I was still being too mean to Emma. As if my mother wasn't some child trapped in a grown-up's body, or Emma wasn't the asshole in our relationship. There didn't really seem to be a path where a man could conclude that they've *had* no healthy women involved in their lives thus far. "Toxic femininity" wasn't really a concept in this universe, and you'd probably get laughed at *at least* for suggesting that it might actually be a thing sometimes. It was never suggested that all the women in your life might actually have personality disorders; or that if you're mom has one, you're likely to subconsciously look for girlfriends with similar traits until you get therapy for that shit. Now that I'm older, I realize that simply *being Susan's child* is emotionally laborious.

It also often felt like they were seeing patterns where there were none, looking for trouble or misogyny where there really wasn't any; and maybe that they need to remember that sometimes a cigar is just a cigar. "Peak feminism" for me may've been this reading assignment, where a woman worked at an ICBM facility with a bunch of dude-bros, and basically accused them of being sex-crazed perverts because they couldn't help but make even the *missiles* penis shaped, while also referring to them with she/her pronouns. I came away feeling like this woman's entire rant was mostly just projection; as if *she'd* had a traumatic life of sexual violence, and really it's just *her* who's seeing dicks all over the place. I'd implore anyone who thinks missiles are simply phallic-shaped because they were designed by men, to major in Aerospace Engineering and tell the world a more aerodynamic shape to construct them in. Of course, the *point* of the reading assignment was to try and illustrate the value of diversity and feminine input into design decisions; as if the missiles would've been shaped like a tulip instead if only it weren't for that pesky glass ceiling keeping all the ladies out of the men's club.

The class wasn't *designed* to be indoctrination; though I often refrained from speaking my mind, because I felt like it wasn't my place. It make me feel like maybe feminism really *has* started to run its course, despite the challenges women still face. I felt like "feminism" was an ironic choice of name for a movement that purports to advance egalitarianism in society and language.

There were points in the class where I cynically thought to myself, "It's not like we're ever going to talk about *trans* women..." But then, toward the end of the semester, we actually *did* have a chapter on trans people. Though you'd think I'd be excited about that, it sort of just felt *weird* and out of place. Like, this is just an *introductory* Women and Gender Studies class. Why couldn't you just let me sulk quietly about how we aren't talking about people like *me*? I would've gotten over it... Maybe I don't know *what* I want.

> Can I place out of WGS210 like I did E115? I was on *Antijen*, you know... (I didn't actually ask this, obviously.)

There was actually an option, for one of the assignments, of either leaving the house dressed like a woman, or doing *some other assignment* instead. Most people chose the latter option; myself included. You might've expected me to jump at the opportunity, but, no... This gender stuff is *very* real to me. It isn't just a game of dress-up to me. It's what I *am* inside; even if what I *am* inside is just some kind of weird pervert. I feel like it'd be an easier assignment for a cis guy with low inhibitions.

---

I took this analog design class my senior year; and I knew I was going to be bad at it. I was really just into programming and digital logic and shit. It was with this fellow, Dr. Breen I think.[^51] I remember this because of the Half Life 2 antagonist of the same name.

!embed https://youtu.be/u2yhqxyYLUQ?list=PLKs_yEJ-2x5b_ox1Ae1rhihOCPGPpYdZ9

[^51]: I wasn't able to find a Dr. Breen of Electrical and Computer Engineering at NC State when I looked, but I swear he's a real dude. I could have the name slightly wrong.

And, I wasn't that great at it. It was still a pretty neat class, and I remember him being a great professor. It was largely about analog design with field effect, as opposed to bipolar, transistors; something that isn't ideal but is often pragmatically desirable when, for example, an IC might be 95% digital logic and only need a little bit of an analog front end or something. The big project for the class involved designing an op-amp.

This class was at like 8:30 a.m., and may've even been responsible for my future morning coffee habit. I walked in one morning, probably still a little slow from having a smoke the night before and holding a Dunkin' Donuts coffee. And I'd guess I was sipping on this coffee and getting ready to stare at a blank page in some multi-subject notebook, when Dr. Breen opened his PowerPoint presentation for the day and the first slide was a *giant goddamn picture of Lynn Conway's face*.

So, if you were a transsexual (certainly, a trans woman) in the year 2000-something, there were three names you *definitely* knew. They were, in no particular order: Andrea James, Calpernia Addams, and Lynn Conway. They were the face of trans activism throughout the entire decade. I doubt anyone even knows who they *are* today.

My heart skips a beat. I'm probably starting to shake and sweat, and I feel like a spotlight has shone down from the heavens on *me in particular*. I *really* wished I hadn't come to class today. Some panicked voice in the back of my head questions whether Dr. Breen and his alien benefactors can see right through me.

The left side of my brain starts pulling me together. Nobody knows you're trans. Just... take a deep breath. She was like... a professor at Michigan or some shit. Just, try and...

I mean, I've known who she was since forever. Certainly since before I had to pick between Computer Engineering and Computer Science. And, I really *did* choose that path because I wanted to get into hardware and low-level software stuff, it felt like more of a mystery at that age, I wanted a wider breadth of knowledge after being mostly a tinkerer up to that point... but I'd always been *acutely* aware of the fact that Lynn Conway was an accomplished computer *engineer* in particular. And here I was in this 400-level ECE class, at this point thoroughly expecting never to learn anything *about* Lynn Conway as an undergraduate... and this is shaping up to be more than a mere *mention*. I mean, he didn't have a giant goddamn picture of *Carver Mead's* face anywhere in his presentation...

Okay. So Lynn Conway *might've* been a little bit of a role model growing up. Whatever.

With WGS210 still fresh in my mind, I expected it to be one of *those* lectures. We're going to spend a third of the class talking about transsexuals, or transgender people, or whatever we were in the year 2013, and I needed to *act. Fucking. Natural. Pull it together, Ethan!* You're not really even *transsexual* anymore, remember?

Okay. I think I'm prepared now. Nobody here knows about that little phase I went through in middle and high school... and it's going to stay that way, as long as I can play the straight man. And so I'm braced for the punchline to this lecture that opened with a giant fucking picture of Lynn Conway's face as the title slide, and...

There *wasn't* one. The class was about the lambda design rules.

Not a *single. Goddamn. Thing* about Lynn Conway being one of the foremost trans activists of the 21st century. Except for a brief mention that there had just been a write-up about her *very fascinating* life in IEEE Spectrum, and that we really ought to read it outside of class.

And I was *So. Relieved.*

I might've even walked away feeling a little big for my britches; knowing I was probably the only other person in the room that day who knew her deal.

I distinctly remember telling myself something as I walked back to my car, that always makes me giggle when I think about it. No matter how far I make it in life, no matter how notorious or infamous I might become... I just hope I never find my face blown up in some professor's slide deck as large as Lynn Conway's was that day.
