# Male phase (2013-2016)
## Work (2013-2015)

I officially graduated in August, after taking a class over the summer I had trouble scheduling during the school year. I *really* wanted to get into embedded programming at this point in my life, after having thoroughly enjoyed playing with microcontrollers throughout my college experience.

I landed a job at a small company specializing in embedded cellular IoT devices called CrystalSoft. I told people I wanted to work at a smaller company; and it isn't a lie to say I'm really *not* a ladder climber and just wanted to get my hands dirty working on real things. Though the truth was, I had just shy of a 3.0 GPA[^601], and didn't really meet the cut for a job at a "real" company like Cisco or IBM unless the job was something like "sales engineering". I knew I'd rather go back to work at the computer store than be a sales engineer at Cisco, and was concerned I'd be pigeonholed into non- or lightly-technical roles after that point. I was optimistic about advice on the internet claiming your GPA really only mattered for your first job, and frankly I didn't have the money for another semester at NC State.

[^601]: I think I actually had a 3.0 *rounding up, after including my final grades over the summer*.

I've often wondered if I'd have made better grades majoring in computer science as opposed to ECE. I think I picked that pathway, largely because it was more of an unknown[^602]. I'd been playing with Linux for much of my life, but I still didn't really feel comfortable putting a transistor on a breadboard without blindly following a schematic. I think I wanted to increase my breadth of knowledge, but I underestimated how math-heavy EE is. It's probably one of the more math-intensive engineering disciplines, I *really* suck at pure mathematics relative to a lot of other things, and I don't feel like I really even got a sound Calculus education at NC State. Most everyone my age had it in high school, and it seemed obvious that Calc 1 and 2 were taught mostly as a review as opposed to first-time mediocre math students like myself.

[^602]: And not because I wanted to be like Lynn Conway.

I sort of wish there was an "embedded computer science" degree that was ECE 109, 209, 309, 4-whatever-that-embedded-class is, and the normal computer science curriculum; but I didn't really know what I was doing at the time and was too stubborn (and broke, relatively speaking) to change course part-way and be a fifth year senior.

Anyway, I landed this interview on a rainy afternoon over the summer of 2013. I wondered into the office, awkwardly wearing a suit my mother had bought for me at some point in college that was probably the wrong color for an interview. Everyone else in the office was considerably more dressed down, and Kevin cracked some joke about how he'd better not see me dressed that formally again. He handed me a whiteboard marker and told me to write `atoi()` from the C standard library. I produced an optimal implementation of the function on the first try; with only a single minor bug that got the place values backwards, which I found after he had me "debug it" also via whiteboard.

He extended an offer not long after this; which I was inclined to accept, as it entailed embedded programming in C and that's exactly what I wanted to do with my life. I hadn't really found anything else that suited my fancy, and my motivation to keep looking hit an all-time low once I *had* the job.

My lease was up on my college apartment at the end of the summer, and I was able to use my job acceptance as proof of employment to rent a decently-sized townhouse just across I-40 from the office. The rent was $850/month, and by-god I think it might've been my favorite residence to date, all things considered.

---

#note The level of anonymization of major companies that make things like cellular modules is probably going to sound a little silly to folks familiar with the industry. I'm sticking with it, though.

I started working for Kevin toward the end of August. We had a couple small rooms in this larger suite, and I was placed at a desk next to a window. "Shit... I guess I've *made* it", I thought.

I wrote a couple drivers integrating cellular modules into our software stack that I'm not sure we ever actually used, before I was placed on my first project. This was the ill-fated OrangeTrack.

By now, I'd learned a decent amount about our software stack, as well as the history of our company. Kevin got his start working for Bay Wireless, and launched the company with a piece of software he'd written for their ConnectOS platform called CrystalCom. It's purpose was to eliminate the often repetitive task of developing one-off applications to move data from something like an array of sensors to the internet, that would often be flashed onto these modules from vendors like Bay Wireless. To accomplish this, CrystalCom had at it's core a system of endpoints and bridges, which could be connected together to move data between subsystems; usually with the goal of communicating with an outside server using CrystalCom's proprietary ASCII- and binary-based protocols.

The idea was that, assuming the server side could cope with any arbitrary format, you could eliminate the need to pay your engineers to develop a whole new application, and simply provision our turnkey solution with AT commands sent over a serial port. You could bridge a meter reader endpoint to a TCP endpoint, for example; or even an ASCII command interpreter to an SMS endpoint to control the software with text messages.

The company started with a reputation for being a "Bay Wireless house", but Kevin had ambitions of porting the software to cellular modules from other vendors; and even to general-purpose microcontrollers, which might communicate with a separate cellular module over a UART. To accomplish this, he hired senior engineer Steve to create OS and cellular module abstraction layers, which respectively came to be known as CrystalOS and CrystalConnect. These were relatively thin but very cleanly designed layers, in contrast to the sprawling and patchwork nature that often characterized CrystalCom development. CrystalOS simply wrapped the native operating system's threading API and provided abstract data structures for things like linked lists and hash tables. CrystalConnect abstracted the AT command parsing and sequencing needed to set up and tear down TCP and UDP network connections with external cellular modules. We didn't include our own TCP/IP stack, in lieu of leveraging the native platform or external cellular module's network stack.

Kevin had since gotten the company acquired by Massachusetts-based DataCorp, a business that seemed to make most of its money selling $5/month SIM cards for these sorts of little embedded M2M devices that only use a few MB of data a month. He had also since hired senior engineer Dale to work mostly on continuing CrystalCom development (who may've started before Steve for all I know), Colombian-based hardware engineer Miguel to do things like PCB design, and cross-fit dude-bro Brandon to help with shipping and flashing modules.

Which brings us to me. A couple other engineers like Leslie and some other new grad had come and gone, but I didn't really know them all that well, and this document is already long enough without talking about them.

By the time I started, CrystalCom had largely been ported on top of CrystalOS and CrystalConnect; and was now running on the original Bay Wireless hardware via the respective CrystalOS and CrystalConnect drivers, for the most part. One could thenceforth build CrystalCom for Win32, and even debug it with Visual Studio instead of Bay Wireless' proprietary Eclipse-based IDE.

Kevin's vision seemed to be that I would continue extending Steve's porting effort to other platforms, without any shenanigans. This is *not* what happened.

Anyway, Kevin took on as a client a fledgling startup out of Orlando by the name OrangeTrack. Their goal was to sell a GPS tracker in a keyfob-like form factor, that you could attach to your kid or your dog or your backpack to keep from losing it. This was the year 2013 btw, in case some smartass was about to comment on the saturation of the tracking-things-with-GPS market. A differentiating feature seemed to be that the OrangeTrack device had both its own cellular module, and a BLE chip that might be able to detect nearby devices.

Through some series of talks, Kevin managed to convince CTO Joe that CrystalCom was the perfect turnkey solution to power his little device. This was a design decision I would eventually come to disagree with.

Kevin introduced the project to me, as an effort to port CrystalCom onto the ARM Cortex-based STM32. The STM32 would communicate with a ConnectIt-brand GPS module over a UART, for which I think a CrystalConnect driver had already been written by Steve or maybe Leslie. The STM32F2xx series had 128KB of RAM, and something like a megabyte of internal flash ROM. FreeRTOS was to be used for threading, which I think I ended up writing the CrystalOS drivers for, but it's been a while. The hardware specs were a far cry from the reference platform; which had several times the RAM and a much faster CPU. Still, it was figured by Kevin that the goal could be reached by selectively compiling out bits of CrystalCom that we weren't planning on using.

Getting CrystalCom* with some asterisks working on an STM32 dev board by a certain date was Kevin's first ultimatum. And for a while, it felt surprisingly like I was back in embedded systems class. I set up an IAR project, got the thing building, combed through the linker map to get the thing to even fit the BSS section in the 128KB of RAM... I was *thoroughly* excited when I managed to get the dev board to even *boot up* CrystalCom just when I thought I might have to spend a long weekend getting it to work. I managed it by commenting out relatively large swaths of CrystalCom that either wouldn't fit in memory or just wouldn't build with the IAR compiler for some reason. And the margins were still razor-thin; using 90-something of the STM32's 128K of RAM right out of the gate.

One of the asterisks I used in managing to get CrystalCom working on the STM32 was a "fake" CrystalOS registry driver, which always returned a successful result for write requests and a `FILE_NOT_FOUND` result for reads. This obviously meant that this hacked-together CrystalCom build didn't have a functioning non-volatile memory, and creating one was my next major order of business.

The flash filesystem was... *by far* the most terrifying piece of software I've ever written.

#### The flash filesystem
Developers usually have opinions, and by now the opinions that comprised Kevin's development philosophy were becoming apparent. Kevin's biggest, and maybe only ethos, was

Generalize. *Everything*.

He disparagingly referred to anything that did one thing and did it well as "throwaway code". He really wanted to keep the amount of OrangeTrack-specific development to a minimum; instead hoping to produce a general-purpose CrystalCom port that could run on anybody's STM32F2-series microcontroller, with connectivity provided by any one of our supported CrystalConnect devices. As such, I could make very few assumptions about the geometry of the underlying flash memory device. One of those few assumptions was that I would be writing a filesystem a NOR flash, as opposed to a NAND flash.

#note I wrote a lot more about this filesystem and why it was a bad idea, but you probably don't care.

---

Two of the first luxury goods I bought myself after graduating from college were

* A Storz and Bickel Volcano
* A Hitachi Magic Wand

The first point was at least partially spurred by the slow failure of my Iolite catalytic butane vaporizer that saw me through the second half of college.

The second point is probably obvious. I was afraid my roommates would hear me using a vibrator through the thin walls, so I made do in ways that often led to uncomfortable chafing. I tried using a fleshlight to deal with this; but I honestly didn't care for the feel, plus it's a lot of hassle.

Kevin asked me if I knew of anyone else who was looking for a job, and I told him

> No... not really...

Josh had to get some kind of surgery with his rib cage or something, and this set him behind in job-searching with the rest of our graduating class. Although, he didn't seem as hurried as I was to apply for jobs at the end of his senior year. Probably because he had daddy's money or something.

Josh asked if my company was hiring, to which I replied

> Nah, I don't think so... It's a pretty small company anyway. We mostly do embedded C stuff...

Kevin asked a couple more times if I knew anybody, and I said

> Eh, I don't know of anyone really.

I didn't really want to cross the streams. That's how I've always handled my private life, and even aspects of my public one.

Josh seemed increasingly desperate, and eventually I hooked the two of them up. Okay...

Kevin interviewed him, and he didn't say much to me about it except

> He's *really* green...

And I'm thinking "Well, he just graduated, and he wasn't a Linux kid like I was, so..."

Anyway, he ended up hiring Josh because he *really* wanted somebody working on this other crazy idea of his, which I think basically involved porting CrystalCom to a cellular router device.

Kevin did a few more interviews over the next year or two, and *briefly* hired another engineer who quit after like a month. It seemed simple to me at the time; but he always gave people the same `atoi()` question, and usually got widely different implementations of it, even from much more experienced engineers. He pointed to the whiteboard one day on our way back from lunch, where someone had done it with a fucking case statement. I've always wondered where that leaves me in the grand scheme of things. Sometimes I feel like this is my thing, but I also feel like I'm far too disorganized and unmotivated to ever be a Dale or Steve-sort of person.

I think shortly after the new year, I had a bit of an incident that was likely spurred by my new vaporizer.

You see, I was downstairs hitting the Volcano, and I was pretty high... I decided to go upstairs for some reason, and just as I started to walk up I got lightheaded *really* fast. I immediately had this feeling like I was going to faint, and instinctively opened the front door on my way to the couch so that somebody might find me if I didn't wake up.

I managed to unlock the door, and not much else. I woke up on the floor with a *splitting* headache. Judging by how I landed, I'd guess I hit my head on the corner of the coffee table. The floor was carpet, and I doubt that alone would've caused this severe of a headache. I was disoriented and distressed enough that I called my mom, just so I could have somebody on the phone in case I lost consciousness again.

I might've ended up taking some ibuprofen or something, but I thought myself to have more-or-less recovered from the experience by the next morning.

So, like a week after this happened, shit started getting *really* weird. I didn't feel right *at all*, and I couldn't put my finger on what was wrong with me. I'd go into work and just stare at the screen until lunchtime. I remember us having a meeting in the conference room, and I just felt outright *batty*.

I was convinced something weird was going on with my body, and that I had to figure it out *myself* for some reason. I became paranoid that something strange had made it into my weed. In my infinite wisdom, I went to CVS to buy a blood pressure monitor and a blood glucose testing kit. And once I got to CVS, I couldn't figure out what to buy and just stared at the shelves for what might've been over 30 minutes before something like "We've got a code 400" went over the intercom. Whether or not I had anything to do with it, I wouldn't be surprised if I was acting so batty as to arouse suspicion.

I had tinnitus like *crazy*. I didn't even feel like myself. I checked my blood glucose and it was always perfectly normal. My blood pressure was consistently 180 over something. After repeatedly checking the internet and ascertaining that this really was dangerous, I decided to drive to the ER. I got to Rex, told them I'd been feeling *really* weird and that my blood pressure was apparently stupidly high, and they quickly took me back and hooked me up to an EEG which found no abnormalities. I think my blood pressure was only 160 over something when they checked it at the hospital. They ultimately determined that there was no pressing emergency and that I might need to talk to my doctor about blood pressure medication.

I felt *really* paranoid, to the point that I thought I had to hide my cannabis use from the doctors. I didn't think to mention my little fainting episode a week or two prior, which I perceived at the time to be completely unrelated.

I remember after work, driving down Avent Ferry to the intersection at Tryon Rd. And, I was still feeling *really* weird. I was waiting at the light, and suddenly someone started honking. I couldn't figure out for the life of me what they were honking at, and then a second person started honking. Eventually, I found myself at the white line with a green light, and I had *no idea* how long I'd been there. Anyway, I made my right turn onto Tryon Rd.

It was only with several months, or maybe over a year of hindsight, that I finally had my wits about me enough to diagnose myself with...

... A concussion. I had a *fucking* concussion. They really *do* fuck up your brain. I often think of this experience when I hear about the new protocols in football. I survived it, but *man* was I loopy. For like a whole six or nine months, at the start of this OrangeTrack project. So, like, most of 2014.

---

By some point in 2014, I was out of the honeymoon phase with this job. My opinion of Kevin started to be that he was a madman who wanted to solve every problem in the industry with one piece of software. A lot of his ideas were met with pushback from Steve and Dale, who as seniors were in more of a position to debate and haggle with him, as opposed to just asking "how high" like I did. This may've been heightened by the fact Steve and Dale worked from home, giving them more of a buffer between Kevin's day-to-day whims than I had.

Exacerbating the problem was the mounting tech debt I'd accrued in meeting Kevin's deadlines. I hadn't yet learned this industry term, and I actually felt *guilty* for having it. Kevin usually wanted to know as soon as I got thing A working so he could get me working on thing B, and I often wasn't as done as I thought I was with thing A when I told him I was there. I was really self-conscious about the hacking I'd had to do to get CrystalCom working at the very beginning, to the point I didn't feel comfortable checking it in. This only led to me getting further bogged down with tricky merges, and inadvertently made me into a cowboy with this special version of CrystalCom for the STM32 I had to baby. This is something I feel pretty silly about, and I think it was entirely psychological; I don't even think the work I'd done was that bad now that I'm older, but I felt like I had a lot to prove after making mediocre grades in college. I didn't feel like I really had enough time to put my best foot forward, and I didn't want to be judged based on that.

Between Kevin and Joe I was answering to two different masters, and I had to maintain a balance between fighting Joe's fires and keeping Kevin happy by not writing "throwaway code" just for OrangeTrack. The need to implement everything as generic CrystalCom features that could be configured with our extended AT and binary command set drove development to a crawl compared to writing a traditional embedded application, and at times hid useful platform-specific features behind layers of abstraction that needed to be re-worked to expose them in a reusable manner. I fielded a steady stream of issues with my flash filesystem throughout my tenure, gradually eroding my confidence in the 5,000+ line monstrosity. CrystalCom was optimized for neither CPU nor memory, pushing the limits of what was supposed to be a low-power, low-overhead tracking device. Efforts to use lower-power hardware states bore noticeable improvement, but were ultimately lackluster compared to what could've been accomplished with a more streamlined application. I began to wish OrangeTrack could simply be its own application built on top of CrystalOS and CrystalConnect, but this pivot seemed out of the question. Half-jokes about adding an `AT$BLUAZU` command to CrystalCom were generally balked at by Kevin.

Kevin often accused Joe of being a "mad scientist" without a clear direction, whose project would probably fail sooner or later. This started to feel more and more like projection on Kevin's part, as Joe managed to secure more and more rounds of funding for this thing I felt I couldn't keep from moving in the wrong direction. Bearing some sense of responsibility and honor, I expressed my intent to "go down with the ship" in private lunchtime rants with Josh.

---

I had a conversation about my growing mystery with Josh at work one day. I think it started when I wore my Red Hot Chili Peppers shirt, and Josh brought up the time we went to that concert. I started going on about how there was *something* different about me that involved Freemasonry, and the Red Hot Chili Peppers... and apparently Terry and Tommy are in on it? I didn't mention the stuff with Heather; either because it slipped my mind, or because I didn't want to explain to Josh who she was. I think it was the latter.

When I left work for the day, this fellow Bill who worked for us as a salesman stopped me near the front desk.

> I overheard you talking with Josh this morning about the Freemasons. I know what your problem is!

Okay... I'm listening...

He made it clear that... whatever I *thought* was important... it wasn't. CrystalSoft? Doesn't matter. My career? Doesn't matter. My so-called "life"? Completely irrelevant. *This* was the thing. "Do you like travelling?", I remember him saying. "... Do you like going places? You don't *belong here*..." If I didn't know any better, I'd say he was shaking in his shoes a bit.

I don't remember if Bill actually used the phrase "blackballed"; but I've come to associate it with this conversation, because it's one of the few things I can confirm Freemasons actually *do*.

Bill suggested the problem had something to do with my *appearance*; or perhaps, my beliefs or lifestyle choices. "Do you have any political signs outside your house?", he asked. I think he might've also asked if I had any enemies, or if there was anything controversial about me. I thought I was a pretty likable person, if not introverted and a bit hard to relate to.

I'm thinking there *is* one thing that sticks out like a sore thumb: I'm a pot-smoking kinkster. If Freemasonry is the sort of venture where I have to look "normal" or "restrained", or refrain from "unacceptable lifestyle choices" that don't hurt anybody... I don't think it's for me. I don't care how cool it is. If my "lifestyle choices" are problematic, well... fuck you.

While Bill sounded as serious about this as anyone back then... I'm afraid I just didn't crack the case. I started getting the impression that I might have the insurmountable task of winning a popularity contest; something I've never been particularly good at.

---

Josh and I had both grown frustrated working for Kevin, but Josh was more inclined to do something about it. He got a job at a startup that was making some sort of ill-fated pill dispenser, while I doubled-down on waiting out OrangeTrack and going down with the ship.

I remember August 2015 being a big month. CrystalSoft changed hands from DataCorp to ConnectIt, one of the better cellular module manufacturers.

I lost my dealer from college, and had no other way to score weed. I drank a little more to take the edge off during this time, but not like *drinking*-drinking. It's really never been my vice, and the equivalent of two or three beers after work would have me forgetting about the whole pot thing.

Shortly after that, the acquisition happened and there was notice that we'd be drug tested. That never happened, though. What a month.

So it's September 2015, and I'm now working out of the ConnectIt office in Morrisville. It felt like I could've been done with OrangeTrack a long time ago if I didn't have to make it work with CrystalCom. Josh has come and gone, I don't really *want* to keep working for Kevin, and morale was at an all-time low. My new commute into Morrisville was considerably elongated, but it still wasn't terrible all things considered. The office was a bit more formal and mostly sales folks, and I felt compelled to dress a bit nicer. The bathrooms kinda sucked, which was a bit of a sticking point because I was picky about bathrooms even back then.

In an ironic twist of events, Joe switched his cellular module from ConnectIt to Data Blocks just as we moved into the new office. We had the dev kit for the new module sent to somebody's home address out of fear Data Blocks would put the kibosh on us. This was a theoretically minor change given we already had CrystalConnect drivers for Data Blocks; but we ended up having some weird problems that were ultimately traced to our test units having some flaky prototype version of the module on it. There was a lot of tense finger-pointing as Joe and I worked to figure out what was wrong with the new boards, and it probably took close to a month for me to definitively prove that the new Data Blocks modules were locking up without our software stack being involved at all.

Though we worked out of the Morrisville office, we were absorbed into this division that actually operates out of Ft. Lauderdale. We were flown down there for a week, and it seemed they'd really like us to think about moving down there eventually if we wanted to stay with the company; no pressure or anything. I'd probably be more enthusiastic about that now; I really felt like I had a life for myself in the Triangle back then, but now I feel I could stand to meet different people and see more of the world.

By now, I wasn't taking the idea of working for ConnectIt long-term all that seriously; despite the fact that they didn't seem like a bad company to work for or anything. I was kinda just sick of Kevin and CrystalCom.

## Play (2013-2015)

Erika and I stopped doing things right around the time I graduated. The reasons were multi-faceted; Erika wanted something more serious than I did, with a former roommate and fellow kinkster named Jason. Jason wanted something more monogamous, and didn't really feel comfortable with Erika and I sceneing in even a non-sexual capacity. I respected that; and honestly needed to find something more serious in the long term anyway.

It wasn't too long after I graduated, when I found myself once again at the weekly slosh. Most of them will never be written about; but, this one is different.

I don't recall how, exactly, but somehow we got to talking about UFOs. And it turned out, much of the table "knew the truth about UFOs". Myself and a few others had *no* idea what the fuck was going on, and one person seemed to just be into "UFO conspiracies". But, most of the table seemed to know something I didn't. Like, they seemed serious; and they didn't appear to be in a cult.

I mean; I doubt this really happened *now*. But, I'm leaving all the weird Slaughterhouse-Five shit...

After doing a double take and asking myself "Really? UFOs?", I spoke up. "Wait, does somebody think they know 'the truth about UFOs' or something?" And, *Maureen* of all people answered my question. I'm obviously paraphrasing because my memory isn't that good.

> Yeah, lots of people know it. It's really not that big of a deal. It's actually kind of a big joke.

So I'm like *citation needed*; and Maureen asks what everyone believes in, and if anyone "works for the government". Nobody within earshot seemed to be religious. I'm thinking, that's probably not a watertight strategy, but go on...

Maureen then says "the thing".

> So, it's just reincarnation.

I had a huge lightbulb moment.

> Ooooohhhhh. Like *Heather*. She never said anything about *UFOs*...

Now I'm thinking, shit man. What does Heather have to do with UFOs? Does she get abducted by them? Does she fly them? Does she get to meet space aliens? I guess that's kind of a given, right? I didn't think it was like *that*. I thought she just remembered a past life on another planet or something. *Dude.*

Of course, I wanted more information; and like all the sketchy fucks who came before, she had little to give. I came away with a few more bullet points.

* Yes, they get to meet space aliens. I think she said that mostly happens "out west" or some shit.
* They're just different. She made it sound like some people were more open about it than others, but it was generally a private affair.
* You kind of just have to... learn about this stuff from one of the different people, I guess?
* She made the Freemasons sound almost like a joke; like "reincarnation" *was* Freemasonry's big secret. She said there are *children* who have the equivalent knowledge of a "33rd degree Freemason".
* At one point, *someone else* at the table told Maureen, in a friendly yet somewhat aggressive tone, that she needed to know "how she knew that". Maureen responded that she had a friend named something-or-other... who was also from Vega I think? This appeared to satisfy the woman's query.
* The government doesn't know much about it; or maybe they *do*, but they lack any real control over the phenomenon. She made it sound like maintaining the "appearance of control" to the general public was the government's main concern.
* I think she said something to the effect of the government pulling some kind of "stunt" in the future regarding the UFO phenomenon; but that it would all be bullshit, and we shouldn't trust the mainstream government narrative.

I felt... confusingly behind in this conversation. Like I was the *one* country bumpkin at this table who *didn't* already know "the truth about UFOs". Like, y'all. I grew up in *Bladen County*. I went to *Bladen Lakes Primary School*. I figured maybe it's common knowledge among folks who grew up in the city, with secular parents and whatnot.

At the same time, I felt like I *had* learned something a bit exclusive. Most of my peers from Bladen County probably still go to church unironically; Maureen may not've said "the thing" at all if one of them had been at the table and spoken up.

I went home that night, once again unsure what to do with all this new information. I always figured that if there was something different about me, folks better start explaining it. All I ever get is this dismissive advice to "follow my path" and "seek hidden truths" and "explore mysticism" and shit.

I actually remember this subject coming up *a couple more times* with this group.

#TODO Finish maybe; it doesn't really matter though.

---

Not too long after I graduated, I was invited to Maureen and Isaac's birthday party. Their birthdays are a few weeks apart, and so they had a combined party at Maureen's house in Ben.

The parking situation was messy. It's been too long for me to remember why I couldn't find anywhere to park on the side of the road *in bum-fuck Ben*; but anyway, I ended up double-parking in the driveway with about a half dozen other people. Lots of people were spending the night; I wasn't *planning* to, but my car got blocked in by someone, and I only put a small amount of effort into finding out who before deciding that "When in Rome..." adage isn't terrible life advice.

I remember looking at my phone that evening and seeing that I didn't have any signal; but I didn't think much of it. It was the weekend.

We all woke up the next morning and were slow to get around. Pancakes were made. A lot of people took showers. I kept looking outside every once in a while, and I was still blocked in. It was *solidly* mid-afternoon before I left.

So, I'm a *little bit* of an introvert. I like going to small parties, but then I like going back home and spending the rest of the weekend recovering. We were already well into Sunday afternoon, and it would be almost dinner time before I got back.

At the same time, I don't get out much; so I *do* like to seize the moment, at least when it's convenient for me. I don't generally have any regrets about seizing this particular moment, though the next part *does* get a little messy.

I unlock the door to my 2001 Ford Mustang. I plug my... I don't know, Samsung Galaxy S4[^22] into my cassette deck adapter, I put on some music and I take off.

Her house wasn't very far from I-40. It was off a major road, and I didn't need the GPS to get back. I was probably about a mile from the exit, when I heard my text message ringtone go off. I briefly thought to myself "Who's texting me at this hour?!" before realizing "Oh, I just regained cell service. That's just my mom texting me goodnight like she does."

Another ding went off. I thought "Huh. I'll look at it when I get back".

My phone started *blowing up*. Fuck.

About a half mile from the exit, I pulled off onto a dirt road in a panic. *What the fuck happened while I was away?!*

I'll tell you what happened while I was away. Sometimes Susan would decide to call me, usually on Saturday nights, to catch up; and I suppose, to see that I was alright. This didn't happen *every* Saturday night; so it's not like I viewed it as some obligation I needed to block off on my weekend schedule.

[^22]: There's a chance it might've been my iPod Classic... But, I think I remember hearing the dings over the stereo.

You probably see where this is going. Remember what I said earlier about Susan?

> Susan is very high-strung. She's emotionally volatile, she panics, she's anxious, she worries about *everything*. She has good days and bad days. Some months it could feel like mostly bad days.

She basically just *assumed the worst*, based on the fact that my phone went straight to voicemail after she tried to call me on Saturday night, and I didn't have signal again until the middle of Sunday afternoon.

She talked to Josh. So, she knows I was alive when I left work on Friday. That means...

... Something *terrible* must've happened to me in the last 24–36 hours!

I got a text message or three from damn near everyone my mom knew to get a hold of; as if they'd get a response if they sent more of them or something. My mother had driven up to Raleigh earlier that day to look for me, and left a note on my door. *I had been missing for less than 24 hours, on a weekend.*

My mother's justification for panic, in this and most similar situations, is that this *never happens*. When a routine gets ingrained in her mind that involves a-widdle Efan; *for example, that she calls me sporadically on Saturday nights when she doesn't have anything going on in* her *life*, that routine now *can't be disrupted*, or else she'll flip the fuck out like Rainman if you give him underpants that aren't from the K-Mart in Cincinnati, Ohio.

!embed https://youtu.be/cso7nzw8j0I?t=70

I could tell this was going to be a problem early on in college, and thus started "weaning her off". I didn't answer the phone right away, even if I could; because if I honest-to-goodness *can't* or *shouldn't* for some reason, this woman will *freak the fuck out*.

Weaning is exhausting, though. Sometimes you just want to get it over with before you forget, but you have *got* to get this woman used to you not being around right away. Or else... this shit will happen. I guess I got complacent and answered my phone right away on Saturday night too many times in a row.

I called my mother in a panic and explained that I was okay. I wasn't immediately forthcoming about where I'd been, because I *really* didn't want to explain I'd been hanging out with kinksters. I needed to spend a couple of minutes calming down to understand that *there was no need to tell anyone they were kinksters*.

I have to admit though; at that moment, it must've felt like my mommy "caught me tying myself up" again.

When I got back in Raleigh, my mother was *loaded* with fears about where I'd been. Among them? That I left the country to get a sex change operation and didn't tell anybody.

---

Toward the middle of the decade, I had grown frustrated by the apparent lack of people to scene with. After getting off to a strong start in college, things seemed to stagnate for me after I graduated. I was seeing the same people at the same events, and I didn't get the impression any of them wanted to top me. To be fair, I rarely asked; but I guess, I want to be wanted, or something? Like, I want someone to have their way with me enthusiastically because they chose to, not because they were bored and I asked nicely. Does that make sense?

This sort of gets at a general dichotomy I had begun to notice between what could be called masculine and feminine submissiveness. Male submissiveness is based around service and humiliation; female submissiveness more on objectification and discipline. I began to realize part of my problem is that I wanted the latter, not the former.

But, the bigger problem was that I didn't really even know *who to ask*. There were maybe a couple prominent dommes with pretty full dance cards. I was starting to think about guys more, but that seemed even harder than finding a domme; although maybe I was counting myself out because I didn't think anyone would *want* to play with me over some cute little rope bunny, and I rarely took it upon myself to *ask* as guys are so often expected to do.

When I first got into kink, I saw "top" and "bottom" as abstractions of the traditional male and female sexual roles. But, I don't think that's accurate anymore. There's masculine toppiness and feminine toppiness. Masculine submissiveness and feminine submissiveness. In a four quadrant grid, like the political compass or something. Most people don't have the problem of being the wrong gender in the four quadrant grid, *unless they're fucking transsexual or some shit*.

As I grew more frustrated, it didn't so much matter that I wanted the top to make the first move, because there didn't seem to really even be much of a reserve of queer male tops and straight female tops to awkwardly try and chat up to see if they'll top me.

My first thought is that I needed to find a *much larger* scene. I planned to start driving to Atlanta and DC on the weekends to explore the respective cities' kink scenes. This was actually part of the reason I ended up going with GPS and blind spot monitoring on my then-new car.

I never actually *did* this. Maybe it's because I'm bad at following through on things. Maybe it's because I'm a lazy pothead. A big part of it is that I started thinking about the numbers. These cities had more people, sure; but their populations weren't so much larger as to turn a thimble into a kiddie pool; much less a full adult-sized dating pool.

I felt I had a very different problem to solve if I ever wanted to find a sexual partner; whereas normal people needed to solve the "fish in the sea" problem, I needed to solve the "needle in a haystack" problem.

I observed that all extant online dating platforms seemed to be geared toward the former problem, and not the latter.

It was around this time when I grew obsessed with the problem of rape. In particular, I was deeply bothered by the fact that there exists both *rape* and *lonely bottoms and submissives*. To me, the act of rape felt, not only heinous, but also *illogical*. I began to wonder how many men become rapists, simply because they believe no consensual outlet exists for their sexuality. I started hypothesizing that I could put a dent in the rape epidemic *and* get myself a date, if I could only match up the pots with the lids.

## The year before the breakdown (2016)

Toward the end of my tenure at CrystalSoft/ConnectIt, there were a lot of things on my mind.

* I was 25 years old. I could maybe get myself tied up and beaten with stuff, but I felt like I was *completely* stuck with regard to my actual sex life.
* I was working on this absolutely hopeless project. I could tell this thing was *never* going to work right unless I could rewrite it as a custom application on top of our software stack, and pay off tech debt incurred from writing shit like the flash filesystem; things Kevin would never let me do. It felt like I was on a sort of death march, where I either needed to quit or wait for the project to fail, and the project wasn't failing quickly enough. Plus, I began feeling guilty that this outside customer of ours kept pouring money into something I didn't really believe in.
* I was *burnt. Out.*
* I wanted to try online dating, but a cursory look made everything seem shitty and gender-y and vanilla.

Really, my core problem was that I wanted to get *fucked*. Or maybe just find a date, but I'd grown to see myself at not a *marriage and family* kind of person; so I'd written off the normal dating pathway as an option for me. I needed to commit to being either a twink or a woman for something to happen, and I'd been too chicken shit to do either.

---

My death march at work had left me demoralized to the point that I was determined to quit my job sooner rather than later.

Among other systemic problems were that CrystalCom was a bad fit for the OrangeTrack project, and even had a number of design flaws for their use case. Whereas CrystalOS and CrystalConnect would've been useful on their own, having to do everything through CrystalCom felt like building a Rube Goldberg machine. It was slow and inflexible, and the AT and binary commands that had to be generically implemented for each new feature were incredibly tedious to work with. While the intent was for Joe to write his own CrystalCom setup script that he could tweak, in practice I had to write the backend feature *and* figure out the CrystalCom script that would use it in a way that hopefully suited Joe's needs.

There was an additional problem with the "stall flag", a sort of afterthought with CrystalCom's endpoint system. A limitation was that it was really designed as an abstraction for stream-like transports, like files or TCP sockets. In an effort to support frame-like transports like UDP or SMS messaging, endpoints were given this stall flag, which could work like a sort of "end of file" signal. When an endpoint has its stall flag set, it can't accept any more data until it's receive buffer is empty.

The problem with the stall flag, is that there's no real flow control, so it only works reliably if the frames are being sent slowly enough for the endpoint to handle them. It turned out OrangeTrack was the first customer to actually *use* UDP in CrystalCom, and the fact the endpoint system couldn't actually queue up multiple UDP packets in either the RX or TX direction *really* sucked. There were a lot of server communication problems that ultimately boiled down to this, and all we could do is hack around it. It's been a long time, but I think it was fair to say UDP was basically broken (or at least crippled) in CrystalCom.

One of my last straws, was when the time came to port my little filesystem onto the OrangeTrack SPI flash. Though it sounded like a fun project back in 2013, by now the flash fileystem scared the *shit* out of me. I just didn't have the time to work on tech debt related to it, and frankly I shouldn't have made it at all.

Once we'd written the SPI and I2C subsystems, this seemed easy enough. And, it was. Writing the driver for it may've even been relaxing.

After testing my new driver and briefly scratching my head when it seemed to not work at first, I found that it *did*, in fact, work just perfectly.

The problem, was just that this filesystem was *impossibly* slow over SPI. The fact that reading a file involved traversing a linked list of all the file's stale metadata since the last garbage collection made the filesystem *surprisingly* read-intensive. This was not noticeable with the STM32's internal flash memory, but introduced a deal-breaking amount of latency when the same operations had to be done over a comparatively slow serial bus.

What's frustrating about this, is that early on Steve and I wanted to spend an extra month or more *really* testing this thing; and, Steve's suggestion that we test it with an external SPI flash was shot down by Kevin, who argued that we didn't have time for me to write "throwaway code" before having SPI and I2C as part of CrystalOS and/or CrystalCom.

Adding to the frustration was that Kevin didn't really have a clear picture of how all these layers were supposed to fit together in the end. He fed the project to me as a simple series of steps, but by now I felt like I was assembling a piece of Ikea furniture with really bad instructions. For example, Steve had already *made* a CrystalOS registry subsystem for storing small bits of non-volatile data. The API for it was designed to make it easy to write a CrystalOS registry driver directly *for* something like a SPI flash with a lot of tiny erase blocks.

However, Kevin wanted to generalize *everything* to the extreme, pushing me to make this highly generalized filesystem that would work for large files, lots of files, and large block sizes. This turned out to be misguided at least; we didn't (and really, *couldn't*) use my filesystem for firmware updates, which was Kevin's main reason for us needing to support large file sizes. The FOTA update bits are *really* low level, and require the firmware image to be in some contiguous space in memory. I ultimately reserved a couple blocks of the STM32's internal flash for this.

So, instead of writing a simple little "throwaway code" registry driver for OrangeTrack's SPI flash, Kevin had me write this overly-complicated thing we didn't need, and it didn't really even work right. I then had to write a CrystalOS registry driver for my flash filesystem, which did the job but just felt awkward. I'm pretty sure Steve and I *both* would've made our respective APIs a bit different if we knew they were supposed to glue together. But really, I think a simple driver for Steve's registry could've been written directly for Joe's SPI flash in a few days.

---

My earlier resolve to "go down with the ship" had given way to something else. I was nauseated that Joe kept securing more and more rounds of funding for this project I knew was being done the wrong way, and I felt entirely powerless to do anything about it. I was burnt out, and I needed to do something *very* different.

I sent out some job applications, but I didn't really get anywhere before giving myself an ultimatum.

My mother wanted us to go along with my high school English teacher's trip to Europe; which she assured me would be totally normal. I went my senior year without Susan. Anyway, I agreed to go, and I was *not* taking off work for it. I was just planning not to *have* work by then, one way or another.

I've never actually *told* anyone I quit my job working for Kevin because I wanted to make a dating app that would work for somebody like me and then proceed to use it. I've sometimes made oblique references to this, telling people I wanted to "focus on side projects" or something more entrepreneurial.

To be honest, I just didn't know where else to *go* with what I was. I didn't think I was a woman; and BDSM is fun, but I was obviously still missing something.

I already talked about wanting to drive to Atlanta and DC on the weekends in search of a bigger kink scene. I just wasn't meeting new people as quickly as I had when Erika and I were doing stuff in college. Yeah, I'm shy and socially awkward; but ignoring that, I didn't even really know who to be shy and socially awkward *toward*. I guess I always felt like a bit of an "acquired taste" with the whole quasi-transgender subby boy thing going on, and it seemed like it would be infinitely indispensable to simply have a mere *list* of gay male tops and straight female tops who were looking for, well... *that*.

I did the math in my head, and I figured *sure, there are more people in Atlanta and DC.* But the thing is, there aren't *that* many more people. I could maybe expect the BDSM community to be around 3–4 times the size of the combined Research Triangle-Piedmont Triad area. But, it seemed like that would only increase my prospects from zero to maybe a half dozen or less. I started to feel like there was a deeper problem to solve, and I couldn't help but feel like there are others like me out there *somewhere*.

I saw that people like me have a very different dating problem from normal folks. Whereas ordinary people need to solve the "fish in the sea" problem, I needed to solve the "needle in a haystack" problem. I concluded that this was a gap left by seemingly all extant dating sites; and that I would have to bridge this gap if I ever wanted to find someone I was compatible with.

In figuring out how to approach this thing, my biggest problem seemed to be my energy level. After writing code for Kevin all day, it was usually the *last* thing I wanted to do once I got home. And if I *was* going to do that, I'd probably feel guilty for not just working on the insurmountable tech debt I'd accrued at my job. I eventually decided that I wanted to do anything *other* than software development as my day job, with the hope that I would have more energy and motivation for side projects during my off hours. I just wasn't happy, and I didn't think anybody would ever notice my talent or pay me what I was worth working for somebody like Kevin.

An obvious pivot in my mind was to get Cisco certs and be a network engineer. I thought about getting a CCNA (and, I have no doubt that I *could* do this), but this seemed a little too time-consuming for the timescale at which I now wanted to escape this job. I was going off to Europe for like two weeks in March, and I did *not* tell Kevin about this.

I wasn't getting anywhere with job applications; probably because I was getting filtered out for being over-qualified for a lot of IT work. Realizing this, I decided to make a "dumbed-down" resume that downplayed my software development experience.

Aiding this effort, I decided to get one CompTIA certification every weekend for the next few weeks; getting my A+/Network+/Security+ all in the same month with zero studying. I figured I might go back for the CCNA eventually; but I could tell I'd need to do at least a *little* studying for that one given my lack of experience with IOS.

I gave Kevin two weeks notice at some point in February, with 20k in savings and no solid prospects.

I was a finalist for a job working for a company off Duke St. that did multimedia installations, but they wound up going with the other guy. I think the tie-breaker question was

> How afraid of heights are you?

They did work for Duke Chapel, and this sometimes involved going *really* high up on ladders and scissor lifts and shit. I was like "eh... maybe a *20-foot ladder* or something...".

In between quitting my job and going off to Europe, I had an interview with a small IT company out of Chapel Hill called Synapse IT. It was a simple job, but I *really* liked the atmosphere. I walked into their warmly-lit office and met the soft-spoken husband and wife team that manages the business, along with their lead tech Justin. I thought to myself

> This is *it*.

We really seemed to like each other, and I came away feeling like I had a pretty good chance at getting the job.

The trip to Europe was... eh. I came away telling myself that I *never* wanted to spend ten consecutive days with Susan again. I'm not really a fan of tour groups in general, and going back with this younger high school class I didn't really have any connection to just felt a little weird. I wished I had just saved my money.

I got a formal job offer from Synapse IT while I was in Europe; however, I didn't tell Susan just yet. She didn't know I even *quit* my job, and I just didn't want to deal with... *her*. She quickly found out through Josh and was all like "WHY DIDN'T YOU TELL ME???"

I took a 30k/year pay cut to run away to Chapel Hill and fix computers; and I *never regretted a moment of it*.

I remember they wanted me to shadow Justin on a Friday for a little bit, which I think happened shortly after I got back. Friday morning was when they would go over all their outstanding issues, and they tried to keep the rest of the day open to tie up loose ends from earlier in the week. I went around town with Justin, checking on servers and I think replacing a UPS battery and a mini-switch along the way. And it was

*Sooo* chill. Like, this shit is *relaxing* to me, dude. I mean, *that's* what it was always about for me. Love what you do and you'll never work a day in your life, or whatever. I'm no ladder climber. I'm actually kind of a slacker, and I don't really like doing homework. I dick around with this stuff for *fun*, and I don't want my computer-related job to stress me out.

---

Around the spring of 2016, I was invited to a party at Erika and Jason's apartment in Knightdale. Heather was there. I hadn't really seen her much the last couple of years, since Erika and I stopped doing things.

We started playing Rockband at one point in the evening. They had the whole set with the drums and shit, so that was cool.

At one point, some dude I didn't know played Can't Stop by the Red Hot Chili Peppers. Heather started snickering about it with me.

> I love knowing what this song's *actually* about...

> *(beat)*

> Wait; what do you mean?

> Well, you know where I'm from, right?

I thought to myself "uhh, like Ohio or something?..." before *my life started flashing before my eyes*.

Ooooohhhhh. The *thing*. Heather's from *Vega*, or Lyra or wherever.

Shit. What was that thing with the Red Hot Chili Peppers, and the Freemasons, and the, uh...

> You figure out where you're from yet?

Well, I figured out where *Anthony Kiedis* is from... I guess?

> Oh... look, I'm not...

She told me I was going to be cool in the future, but I wasn't ready yet.

Then, I'll be damned if she didn't say she had *a vision* of us all going to a concert in a few years; which I presumed to be a Red Hot Chili Peppers concert. My memory isn't perfect. "Now you're starting to sound like that crazy old man Tommy Warren!", I said.

I'm pretty sure I asked, like always, if there was anything I should actually be *doing*. And, I'm pretty sure I got the same sort of dismissive "follow your path, you'll get there someday" advice that I always get from these sketchy fucking people.

---

In the latter half of 2016, and shortly after moving to Chapel Hill to shorten my lengthy commute from highway 86 to Gorman St, I experienced what might've been a minor version of what started happening to me a few years ago.

After losing my dealer back in August 2015, I managed to find weed for the last nine months of the year. I couldn't say if this is related, but I suppose I ought to mention it.

Aliens. I don't know *what* got into me; but I had this overpowering sensation, for maybe several months, that space aliens (for lack of a better word) were involved in my life. And, they wanted to tell me... nothing, really. Except that they existed, they were around, and they thought I should know that.

I had to get all four of my impacted wisdom teeth extracted in my mid-twenties some time before the ConnectIt acquisition; and while high on Percocet and flipping through cable television channels[^603], I managed to find Ancient Aliens; a show I tended to *avoid*, out of some combination of my love for hard science, and perhaps some overall cringe factor. The mildly-intoxicated state I was in led to me making slightly different decisions, as I belly-laughed at the announcer who incredulously posed the pre-commercial break question "Could the moon... be *hollow?!*"

[^603]: I still had cable television lmao

This began the start of a months-long tradition, where I would go out of my way to watch new and old episodes of Ancient Aliens *in the most ironic way possible*, in search of that same feeling I had the first time; usually while under the influence of cannabis or alcohol.

For the more skeptical-minded person who might want for a more plausible explanation for my late-2016 experiences, I suppose I could float the combination of Ancient Aliens and the end of a nine-month-long cannabis dry spell as one possibility.

It may've started when an ostensible Ancient Aliens fact actually managed to catch my attention enough, that I now needed to look something up on my phone independently. I also had that weird experience with Heather a month or two before this happened to me.

It's been a while, but I didn't really get into weird shit on the internet or anything; except for maybe that very early stage where something piqued my interest. And, I didn't have this feeling like I was special, or in danger, or like anything big was about to happen on planet Earth. Again; it just felt like aliens were involved in my life at a distance, they were watching me, they were around in the craziest of places when you'd least expect it... and they just want me to know that they're *there*.

I looked up at the night sky a lot, but I never saw anything. I remember wondering if some of the strangers I encountered in my day-to-day life might know more, or even be aliens themselves. I only remember it spooking me out a little at first, really.

This phase ended sometime around late December; after which I kind of just assumed I maybe went a little nuts and decided to bury the whole thing. I coincidentally stopped using cannabis again around the same time; and didn't start smoking heavily again until late 2020.

Although I remember that weird exchange with Heather earlier in the year *now*, I don't think I even *thought* about her during this weird "alien whisperer" phase later in 2016.

---

I quickly assimilated at my new job, and really liked it despite the lower pay. There were a lot of good things about the job, really. I drove around town a lot, and I think the changes in scenery really helped my brain context switch. I like how IT work is more episodic and chunked smaller; although I like software development, I feel like I often get stuck with large multistep projects that take weeks or months to complete. I liked how I could keep checking off the list with IT work; and I always went home feeling like I made progress and earned my pay. That often wasn't the case with software development, where I'd sometimes go home feeling like I accomplished nothing that day and basically committed wage theft.

I'm probably just being hard on myself, though. Programming can be like that sometimes.

I quickly learned through our Friday meetings that Synapse did IT work for Mobile Development. I actually had to go to their website, because I figured it's a generic-sounding enough name that there might be two companies called "Mobile Development", but... no, there's only one MobileDev.

Mobile Development was, in a lot of ways, a direct competitor to CrystalSoft. I'd liken the relationship between the two companies as that of Black Mesa to Aperture Science. I immediately grew wary I'd be accused of corporate espionage, and told Justin I'd rather stay away from MobileDev if I can.

Despite them mostly being Justin's customer, I *did* need to go to MobileDev on occasion; where I'd often find the engineers using Steve's CrystalTerminal application, a quite-good replacement for the no-longer-extant Windows HyperTerminal.

#TODO I could write more about my time at Synapse IT, but it doesn't matter right now.
